"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mentionServices = void 0;
exports.isMentionTextChar = isMentionTextChar;
exports.isValidMention = isValidMention;
var char_utils_1 = require("../char-utils");
var mentionRegexes = {
    twitter: /^@\w{1,15}$/,
    instagram: /^@[_\w]{1,30}$/,
    soundcloud: /^@[-a-z0-9_]{3,25}$/,
    // TikTok usernames are 1-24 characters containing letters, numbers, underscores
    // and periods, but cannot end in a period: https://support.tiktok.com/en/getting-started/setting-up-your-profile/changing-your-username
    tiktok: /^@[.\w]{1,23}[\w]$/,
    // Youtube usernames are 3-30 characters containing letters, numbers, underscores,
    // dashes, or latin middle dots ('·').
    // https://support.google.com/youtube/answer/11585688?hl=en&co=GENIE.Platform%3DAndroid#tns
    youtube: /^@[-.·\w]{3,30}$/,
};
/**
 * Determines if the given character can be part of a mention's text characters.
 *
 * Accepts characters that match the RegExp `/[-\w.]/`, which are the possible
 * mention characters for any service.
 *
 * We'll confirm the match based on the user-configured service name after the
 * match is found.
 */
function isMentionTextChar(charCode) {
    return (charCode === 45 /* Char.Dash */ || // '-'
        charCode === 46 /* Char.Dot */ || // '.'
        charCode === 95 /* Char.Underscore */ || // '_'
        (0, char_utils_1.isAsciiLetterChar)(charCode) ||
        (0, char_utils_1.isDigitChar)(charCode));
}
/**
 * Determines if the given `mention` text is valid.
 */
function isValidMention(mention, serviceName) {
    var re = mentionRegexes[serviceName];
    return re.test(mention);
}
exports.mentionServices = [
    'twitter',
    'instagram',
    'soundcloud',
    'tiktok',
    'youtube',
];
//# sourceMappingURL=mention-utils.js.map