<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Mention extends Model
{
    protected $table = 'mentions';

    protected $fillable = [
        'mentioned_user_id',
        'mentioned_by_user_id',
        'post_id',
        'post_comment_id',
    ];

    public function mentionedUser()
    {
        return $this->belongsTo(User::class, 'mentioned_user_id', 'id');
    }

    public function mentionedBy()
    {
        return $this->belongsTo(User::class, 'mentioned_by_user_id', 'id');
    }

    public function post()
    {
        return $this->belongsTo(Post::class, 'post_id', 'id');
    }

    public function comment()
    {
        return $this->belongsTo(PostComment::class, 'post_comment_id', 'id');
    }
}
