<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class HashtagLink extends Model
{
    protected $table = 'hashtag_links';

    protected $fillable = [
        'hashtag_id',
        'post_id',
        'post_comment_id',
    ];

    public function hashtag()
    {
        return $this->belongsTo(Hashtag::class, 'hashtag_id', 'id');
    }

    public function post()
    {
        return $this->belongsTo(Post::class, 'post_id', 'id');
    }

    public function comment()
    {
        return $this->belongsTo(PostComment::class, 'post_comment_id', 'id');
    }
}
