<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Hashtag extends Model
{
    protected $fillable = ['tag'];

    public function links()
    {
        return $this->hasMany(HashtagLink::class, 'hashtag_id', 'id');
    }

    public function postLinks()
    {
        return $this->hasMany(HashtagLink::class, 'hashtag_id', 'id')
            ->whereNotNull('post_id');
    }

    public function commentLinks()
    {
        return $this->hasMany(HashtagLink::class, 'hashtag_id', 'id')
            ->whereNotNull('post_comment_id');
    }
}
